<?php
// contact.php — SkyNova Cheque System microsite
// صفحة نجاح/خطأ + إرسال بريد يتضمن جميع الحقول

$TO_EMAIL   = 'info@skynova365.com';
$FROM_EMAIL = 'no-reply@skynova365.com';
$FROM_NAME  = 'SkyNova Microsite';
$RATE_LIMIT_SECONDS = 30;

function lang_code(): string {
  $lang = strtolower(trim($_POST['lang'] ?? ''));
  return in_array($lang, ['ar','en'], true) ? $lang : 'ar';
}
function t($k,$lang){
  $m=['ar'=>[
      'ok'=>'تم استلام رسالتك بنجاح، سنعاود الاتصال بك قريبًا.',
      'error'=>'عذراً، حدث خطأ أثناء الإرسال. حاول لاحقاً.',
      'back'=>'العودة إلى الصفحة الرئيسية'
    ],
    'en'=>[
      'ok'=>'Your message has been sent successfully. We will contact you shortly.',
      'error'=>'Sorry, an error occurred while sending. Please try again later.',
      'back'=>'Back to homepage'
    ]];
  return $m[$lang][$k]??$k;
}
function safe_line($s,$max=200){ return mb_substr(str_replace(["\r","\n"],' ',trim($s)),0,$max,'UTF-8'); }
function valid_email($e){ return filter_var($e,FILTER_VALIDATE_EMAIL); }

session_start(); if(!isset($_SESSION['last_send'])) $_SESSION['last_send']=0;

$lang   = lang_code();
$status = false;

// قراءة كل الحقول (بما فيها الهاتف والشركة)
$name    = safe_line($_POST['name']    ?? '');
$company = safe_line($_POST['company'] ?? '');
$email   = safe_line($_POST['email']   ?? '');
$phone   = safe_line($_POST['phone']   ?? '');
$message = trim($_POST['message'] ?? '');
$website = trim($_POST['website'] ?? ''); // honeypot

try{
  // تحقق أساسي (يمكن توسعته حسب رغبتك)
  $required_ok = ($name !== '' && $email !== '' && $message !== '' && valid_email($email));
  $rate_ok     = (time() - (int)$_SESSION['last_send'] > $RATE_LIMIT_SECONDS);
  $not_bot     = ($website === '');

  if($required_ok && $rate_ok && $not_bot){
    // بناء جسم الرسالة — الآن يشمل الهاتف والشركة واللغة وIP وUA
    $subject='New enquiry — SkyNova Cheque System';
    $body  = "New enquiry from SkyNova Cheque System microsite:\n\n";
    $body .= "Name:    {$name}\n";
    $body .= "Company: {$company}\n";
    $body .= "Email:   {$email}\n";
    $body .= "Phone:   {$phone}\n";               // ← الهاتف موجود هنا
    $body .= "Lang:    {$lang}\n";
    $body .= "IP:      " . ($_SERVER['REMOTE_ADDR']    ?? 'unknown') . "\n";
    $body .= "UA:      " . ($_SERVER['HTTP_USER_AGENT']?? 'unknown') . "\n\n";
    $body .= "Message:\n{$message}\n";

    $headers  = "MIME-Version: 1.0\r\n";
    $headers .= "Content-type: text/plain; charset=utf-8\r\n";
    $headers .= "From: {$FROM_NAME} <{$FROM_EMAIL}>\r\n";
    $headers .= "Reply-To: {$email}\r\n";

    // ملاحظة: إن كانت الاستضافة تعطل mail() فعّل SMTP عبر PHPMailer هنا.
    $sent=@mail($TO_EMAIL,$subject,$body,$headers);

    if($sent){ $_SESSION['last_send']=time(); $status=true; }
  }
}catch(Throwable $e){ $status=false; }

// --- إخراج صفحة النتيجة ---
?>
<!DOCTYPE html>
<html lang="<?= $lang ?>" dir="<?= $lang=='ar'?'rtl':'ltr' ?>">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?= $status?t('ok',$lang):t('error',$lang) ?></title>
  <style>
    :root{ --ok:#16a34a; --err:#dc2626; }
    *{box-sizing:border-box}
    html,body{margin:0;height:100%}
    body{display:flex;align-items:center;justify-content:center;height:100%;
         font-family:Cairo,Inter,Arial,sans-serif;background:#f7fafc;color:#0f172a}
    .card{background:#fff;padding:44px 36px;border-radius:22px;
          box-shadow:0 10px 35px rgba(0,0,0,.10); text-align:center; max-width:560px}
    .iconWrap{width:120px;height:120px;margin:0 auto 18px;border-radius:50%;
              display:grid;place-items:center;color:#fff; font-size:64px; animation:pop .5s ease-out both}
    .ok{background:conic-gradient(from 0deg at 50% 50%, #16a34a, #22c55e, #16a34a)}
    .err{background:conic-gradient(from 0deg at 50% 50%, #dc2626, #ef4444, #dc2626)}
    @keyframes pop{0%{transform:scale(.6);opacity:.2}100%{transform:scale(1);opacity:1}}
    h1{margin:0 0 10px;font-size:1.6rem}
    p{margin:0 0 16px;color:#475569}
    .btn{display:inline-block;margin-top:6px;padding:12px 18px;border-radius:12px;
         background:linear-gradient(135deg,#16a34a,#0ea5e9);color:#fff;text-decoration:none;
         transition:transform .15s ease, opacity .15s ease}
    .btn:hover{transform:translateY(-1px);opacity:.92}
    .confetti{position:relative;height:0}
    .confetti i{position:absolute;width:8px;height:14px;opacity:.85;animation:fall 1.8s linear forwards}
    @keyframes fall{to{transform:translateY(160px) rotate(600deg); opacity:0}}
  </style>
</head>
<body>
  <div class="card">
    <div class="iconWrap <?= $status?'ok':'err' ?>">
      <?= $status?'✔️':'✖️' ?>
    </div>
    <h1><?= $status?t('ok',$lang):t('error',$lang) ?></h1>
    <?php if($status): ?>
      <p><?= $lang==='ar'?'شكرًا لتواصلك معنا. سنراجع تفاصيلك ونتواصل قريبًا.':'Thanks for reaching out. We\'ll review and get back shortly.' ?></p>
    <?php else: ?>
      <p><?= $lang==='ar'?'تحقق من البريد/الاتصال ثم أعد المحاولة.':'Check the email/connection, then try again.' ?></p>
    <?php endif; ?>
    <a class="btn" href="<?= $lang=='ar'?'index-ar.html':'index-en.html' ?>"><?= t('back',$lang) ?></a>

    <!-- لمسة جمالية: قصاصات ورق بسيطة -->
    <div class="confetti" aria-hidden="true" id="confetti"></div>
  </div>

  <script>
  // قصاصات ورق بسيطة (تظهر عند النجاح فقط)
  (function(){
    var ok = <?= $status ? 'true' : 'false' ?>;
    if(!ok) return;
    var c = document.getElementById('confetti');
    if(!c) return;
    var colors = ['#16a34a','#22c55e','#0ea5e9','#f59e0b','#ef4444','#a855f7'];
    for(var i=0;i<28;i++){
      var s = document.createElement('i');
      s.style.left   = (Math.random()*90+5) + '%';
      s.style.background = colors[(Math.random()*colors.length)|0];
      s.style.animationDelay = (Math.random()*0.5)+'s';
      s.style.transform = 'translateY(-40px) rotate(' + (Math.random()*180) + 'deg)';
      c.appendChild(s);
    }
  })();
  </script>
</body>
</html>
